<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\models\users;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\BaseController;
use App\User;
use Illuminate\Support\Facades\DB;

class LoginApiController extends BaseController
{
    public function index(Request $request){
        $param = $request->except('url');        
        $url = $request->url;
        
        Log::channel('api')->info(substr(md5(json_encode($param)),1,8));
        Log::channel('api')->info($url);
        
        if($url != substr(md5(json_encode($param)),1,8)){
            return $this->errorWithInfo('url验证不通过', 401);
        }
        if(empty($param['username']) || empty($param['password'] )){
            return $this->errorWithInfo('参数验证不通过', 401);
        }
        
        $user = DB::table('users')->select('status','user_name','password','user_sn','team_name','password','expired','ai_count','caller_group','api_key','parent_sn')->where('user_name',$param['username'])
        ->where(function($query){
            $query->where('status',0)->orWhere(function($query){
                $query->whereNull('status');
            });
        })
        ->first();
        if(empty($user)){
            return $this->errorWithInfo('您的账号不存在', 401);
        }
        if($user->status == 1){
            return $this->errorWithInfo('您的账号已被清理，请联系管理员处理', 401);
        }
        if(empty($user->parent_sn)){
            $the_expired = $user->expired;
        }else{
            $puser = DB::table('users')->where('user_name',$user->parent_sn)->select('expired')->first();
            $the_expired = $puser->expired;
        }
        
        $todayDate = strtotime(date('y-m-d 00:00:00',time()));
        $expiredDate = strtotime($the_expired.' 00:00:00');
        
        if(empty($the_expired) || $expiredDate - $todayDate <= 0){
            return $this->errorWithInfo('您的账号已过期，请联系管理员处理', 401);
        }
        
        if(empty($user) || !password_verify($param['password'],$user->password)){
            return $this->errorWithInfo('用户名或密码错误', 401);
        }
        
        //生成api_key
        $api_key = $this->create_apikey(8);
        $expire = time()+3600*10; //有效时间10小时
        $data['api_key'] = $api_key;
        $data['api_key_expire'] = $expire;
        $rs = DB::table('users')->where('user_sn',$user->user_sn)->update($data);
        
        $user->api_key = $api_key;
        $user->api_key_expire = $expire;
        unset($user->password);
        
        if($rs){
            return $this->successWithInfo(['data'=>(array)$user]);
        }else{
            return $this->errorWithInfo('登录失败', 401);
        }
    }
    
    private function create_apikey( $length = 8 ) {
        // 密码字符集，可任意添加你需要的字符
        $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $password = '';
        for ( $i = 0; $i < $length; $i++ )
        {
            $password .= $chars[ mt_rand(0, strlen($chars) - 1) ];
        }
        return $password;
    }
}
