<?php

namespace App\Http\Middleware;

use Closure;
use App\Http\models\users;
use Illuminate\Support\Facades\Log;
use App\User;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Tool;
use Illuminate\Support\Facades\Redis;
class CheckApiKey
{
    use Tool;
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        try {
            //$url=$request->url;            
            //$api_key=$request->api_key;
            $user_sn=$request->user_sn;
            //$user_sn=$request->header('user-sn');
            $api_key = $request->header('api-key');//header头里面不能用下划线的参数
            if (empty($api_key) || empty($user_sn)){
                return $this->errorWithInfo('参数验证不通过', 401);
            }
            
            $rKey = 'strategy:login:'.$user_sn;
            if (!Redis::exists($rKey)){
                return $this->errorWithInfo('登陆失效', 401);
            }else{
                $user = Redis::get($rKey);
                $user = json_decode($user,true);
                if ($api_key != $user['api_key']){
                    return $this->errorWithInfo('key验证不通过', 401);
                }
            }
             
            $request->attributes->add(['user'=>$user]);//添加参数
        }catch (\Exception $e){
            Log::channel('api')->error($e->getFile().'-'.$e->getLine().'-'.$e->getMessage());
            return $this->errorWithInfo('验证异常', 401);
        }   
        return $next($request);
    }
}
