import request from '@/utils/request'
// 策略新建
export function addStrategySet(data) {
  return request({
    url: '/api/strategySet',
    method: 'post',
    data
  })
}
// 策略列表获取
export function getStrategySet(data) {
  return request({
    url: '/api/strategySet',
    method: 'get',
    params: data
  })
}
// 话术流程项目列表
export function getProjectsList(data) {
  return request({
    url: '/api/strategy/getProjectsList',
    method: 'post',
    data
  })
}
// 主叫号码列表
export function getCallNumberList(data) {
  return request({
    url: '/api/strategy/getCallNumberList',
    method: 'post',
    data
  })
}
// 子账号列表
export function getUsersList(data) {
  return request({
    url: '/api/strategy/getUsersList',
    method: 'post',
    data
  })
}
// 导出模板
export function downloadModel(query) {
  let str = process.env.VUE_APP_BASE_API || ''
  window.open(str + (str.slice(str.length - 1) === '/' ? '' : '/') + 'api/strategy/downloadModel?user_sn=' + query.user_sn)
}
// 下载失败导出excel数据
export function downloadFailExcel(query) {
  let str = process.env.VUE_APP_BASE_API || ''
  window.open(str + (str.slice(str.length - 1) === '/' ? '' : '/') + 'api/strategy/downloadFailExcel?user_sn=' + query.user_sn + '&filename=' + query.filename)
}
// 导入数据excel文件
export function importExcelData(data) {
  return request({
    url: '/api/strategy/importExcelData',
    method: 'post',
    data
  })
}
// 任务数据列表
export function getStrategyTask(query) {
  return request({
    url: '/api/strategyTask',
    method: 'get',
    params: query
  })
}
// 任务数据编辑
export function editStrategyTask(data) {
  return request({
    url: `/api/strategyTask/${data.id}`,
    method: 'PUT',
    data
  })
}
// 策略删除
export function deleteStrategySet(data) {
  return request({
    url: '/api/strategySet/' + data.strategy_sn + '?user_sn=' + data.user_sn,
    method: 'delete'
  })
}
