<?php

namespace App\Http\Controllers\strategy;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Tool;
use App\Service\StrategyService;
//use App\Http\Requests\StrategySetCreateRequest;

class StrategySetController extends Controller
{
    use ValidatesRequests;
    use Tool;
    
    public function index(){
        dd('策略列表');
    }
    
    public function store(Request $request,StrategyService $StrategyService){
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:30',
            'user_sn' => 'required',
            'call_number' => 'required',
            'day_type' => 'required',
            'frequency_type' => 'required',
            'call_time_set' => 'required',
            'project_sn' => 'required'
        ]);
        
        /* if ($validator->fails()) {
            return $this->errorWithInfo('表单验证失败', 401);
        } */
        $params = $request->all();
        if (isset($params['upload'])){ //excel文件上传
            $excelData = $StrategyService->validUploadExcel($request,'upload',8388608); //限制最大上传文件8M
            if (isset($excelData['code'])){
                return $this->errorWithInfo($excelData['msg'], 401);
            }
            //验证excel数据格式及不合格数据原因
            $excelDataValid = $StrategyService->validExcelData($excelData, $params['day_type']);
        }
        dd($excelDataValid);
        dd('策略添加');
    }
    
    
    
}
