<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Tool;
use App\Http\Controllers\BaseController;

class LoginController extends BaseController
{
    use Tool;
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    
    
    public function login(Request $request)
    {        
        // 1. 获取前端发来的用户名和密码
        $username = $request->input('username');
        $password = $request->input('password');
        $username = 'ljs';
        $password = '123456';
        
        $defaultuser = 'ljs'; //固定一个账号登录
        if ($username != $defaultuser){
            return $this->errorWithInfo('您的账号不允许登录', 401);
        }
                
        //调用小a登录接口
        $url = "https://test117.ciopaas.com/api/login";
        $params = ['username'=>$username,'password'=>$password,'from'=>"2"];
        $params['url'] = substr(md5(json_encode($params)),1,8);
        $requestReturn = $this->requestPost($url,$params);
        //dump($requestReturn);
        $requestReturnArr = json_decode($requestReturn,true);
        if (isset($requestReturnArr['code'])){ //登录成功
            if ($requestReturnArr['code'] == 0){
                return $this->successWithInfo($requestReturnArr['data']);
            }else{
                return $this->errorWithInfo($requestReturnArr['msg'], 401);
            }
        }else{
            return $this->errorWithInfo('登录接口异常', 401);
        }
        
    }
}
