<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // $this->call(UsersTableSeeder::class);
        $tableName = 'strategy_set';//策略设置表
        if(!Schema::hasTable($tableName)){
            Schema::create($tableName, function (Blueprint $table){
                $table->increments('id');
                $table->uuid('strategy_sn'); //sn编号
                $table->char('strategy_name',50);  //策略名称
                $table->char('user_sn',100);  //用户sn
                $table->char('user_name',50);  //用户名
                $table->char('call_number',50);  //主叫号码
                $table->char('parent_sn',50);  //主账号名
                $table->char('project_sn',100);  //项目sn
                
                $table->unsignedSmallInteger('day_type')->default(0);  //外呼日期类型 0每天 1日期前一天和当天
                $table->unsignedSmallInteger('frequency_type')->default(1);//外呼频率类型 （1 一天一次 2 一天两次）
                $table->char('call_time_set',50);  //呼叫设置时间点，两个用#号分割
                $table->unsignedSmallInteger('disabled')->default(1);//是否不可用 0启用 1停用
                $table->integer('total')->default(0);//excel导入号码总数量
                $table->integer('latest_total')->default(0);//最新一次导入excel号码数量
                $table->timestamp('updated_at')->nullable();
                $table->timestamp('created_at')->nullable();
            });
            //加索引
            Schema::table($tableName, function ($table){
                $table->index('strategy_sn');
                $table->index('disabled');
            });
            //加注释
            //$sql = "COMMENT ON COLUMN \"public\".\"seating_assistance_project_set\".\"is_seating_sensitive_word\" IS '是否坐席敏感词 0否 1是'";
            //DB::statement($sql);
        }
        
        
        $tableName = 'strategy_excel';//策略excel数据记录表
        if(!Schema::hasTable($tableName)){
            Schema::create($tableName, function (Blueprint $table){
                $table->increments('id');
                $table->char('strategy_sn',100); //sn编号
                $table->char('name',50)->nullable();  //姓名
                $table->date('duty_date')->nullable();  //值班日期                
                $table->unsignedBigInteger('phone');  //手机号
                $table->unsignedSmallInteger('last_handle_month')->default(0);//最后处理月份，当月处理后不再处理
                $table->timestamp('updated_at')->nullable();
                $table->timestamp('created_at')->nullable();
            });
            //加索引
            Schema::table($tableName, function ($table){
                $table->index('strategy_sn');
            });
        }
        
        $tableName = 'strategy_task';//任务数据（任务已建未建）
        if(!Schema::hasTable($tableName)){
            Schema::create($tableName, function (Blueprint $table){
                $table->increments('id');
                $table->char('name',50)->nullable(); //sn编号
                $table->date('duty_date')->nullable();  //值班日期（年月日）
                $table->unsignedBigInteger('phone');  //手机号
                $table->char('call_number',50);  //主叫号码
                $table->date('call_date');  //外呼时间（年月日）
                $table->time('call_time');  //外呼时间（时分秒）
                $table->char('parent_sn',50);  //主账号名
                $table->char('project_sn',100);  //项目sn
                
                $table->unsignedSmallInteger('is_created')->default(0);//是否新建任务（0未建 1已建）
                $table->unsignedSmallInteger('created_fail_number')->default(0);//任务创建失败尝试次数
                
                $table->timestamp('created_at')->nullable();
            });
            //加索引
            Schema::table($tableName, function ($table){
                $table->index('is_created');
                $table->index('phone');
            });
        }
        
        
    }
}
