<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // $this->call(UsersTableSeeder::class);
        $tableName = 'strategy_set';//策略设置表
        if(!Schema::hasTable($tableName)){
            //创建表语句
            Schema::create($tableName, function (Blueprint $table){
                $table->increments('id');
                $table->string('strategy_sn'); //sn编号
                $table->string('strategy_name');  //策略名称
                $table->string('user_sn');  //用户sn
                $table->string('user_name');  //用户名
                $table->string('parent_sn');  //主账号名
                $table->string('project_sn');  //项目sn
                
                $table->integer('day_type')->default(0);  //外呼日期类型 0每天 1日期前一天和当天
                $table->integer('frequency_type')->default(1);//外呼频率类型 （1 一天一次 2 一天两次）
                $table->string('call_time_set');  //呼叫设置时间点，两个用#号分割
                $table->integer('disabled')->default(1);//是否不可用 0启用 1停用
                $table->integer('total')->default(0);//excel导入号码总数量
                $table->integer('latest_total')->default(0);//最新一次导入excel号码数量
                
                $table->timestamp('created_at')->nullable();
            });
            //加索引
            Schema::table('seating_assistance_project_set', function ($table){
                $table->index('strategy_sn');
                $table->index('disabled');
            });
            //加注释
            //$sql = "COMMENT ON COLUMN \"public\".\"seating_assistance_project_set\".\"is_seating_sensitive_word\" IS '是否坐席敏感词 0否 1是'";
            //DB::statement($sql);
        }
        
        
        $tableName = 'strategy_excel';//策略excel数据记录表
        if(!Schema::hasTable($tableName)){
            //创建表语句
            Schema::create($tableName, function (Blueprint $table){
                $table->increments('id');
                $table->string('strategy_sn'); //sn编号
                $table->string('name');  //姓名
                $table->string('duty_date')->nullable();  //值班日期                
                $table->integer('phone');  //手机号
                $table->timestamp('created_at')->nullable();
            });
            //加索引
            Schema::table('seating_assistance_project_set', function ($table){
                $table->index('strategy_sn');
            });
        }
        
        $tableName = 'strategy_task';//任务数据（任务已建未建）
        if(!Schema::hasTable($tableName)){
            //创建表语句
            Schema::create($tableName, function (Blueprint $table){
                $table->increments('id');
                $table->string('name'); //sn编号
                $table->string('duty_date')->nullable();  //值班日期（年月日）
                $table->integer('phone');  //手机号
                
                $table->string('call_date');  //外呼时间（年月日）
                $table->string('call_time');  //外呼时间（时分秒）
                $table->string('parent_sn');  //主账号名
                $table->string('project_sn');  //项目sn
                
                $table->integer('is_created')->default(0);//是否新建任务（0未建 1已建）
                $table->integer('created_fail_number')->default(0);//任务创建失败尝试次数
                
                $table->timestamp('created_at')->nullable();
            });
            //加索引
            Schema::table('seating_assistance_project_set', function ($table){
                $table->index('is_created');
                $table->index('phone');
            });
        }
        
        
    }
}
