<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
//use App\Service\StrategyService;
use App\Models\StrategySet;
use App\Jobs\StrategyTaskJob;
use App\Models\StrategyExcel;

class CreatedTaskDataCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:CreatedTaskDataCommand';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '每月1号4点创建任务数据';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $setInfo = StrategySet::where([['disabled',0]])->get()->toArray();
        if (!empty($setInfo)){
            //$StrategyService = new StrategyService();
            foreach ($setInfo as $k=>$v){
                if ($v['day_type'] == 0){//day_type 0每天 1日期前一天和当天，为1的时候不需要每月执行，在导入数据的时候统一处理一次就完成
                    //$StrategyService->createTaskDataJob($v['strategy_sn']);
                    $jobParams = ['strategySn'=>$v['strategy_sn']];
                    $job = (new StrategyTaskJob($jobParams))->onQueue('StrategyTask');
                    dispatch($job);
                }else{//修改最后执行月份
                    $cmonth = date('n');                    
                    StrategyExcel::where([['strategy_sn',$v['strategy_sn']],['last_handle_month','<>',$cmonth]])->update(['last_handle_month'=>$cmonth]);
                }
            }
        }
    }
}
