<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\models\users;
use Illuminate\Support\Facades\Log;
use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redis;

class LoginApiController extends Controller
{
    use Tool;
    public function index(Request $request){
        $param = $request->except('url');        
        $url = $request->url;
        
        /*Log::channel('api')->info(substr(md5(json_encode($param)),1,8));
        Log::channel('api')->info($url);
        
        if($url != substr(md5(json_encode($param)),1,8)){
            return $this->errorWithInfo('url验证不通过', 401);
        } */
        //固定登录用户
        //$allowLoginUser = ['user_name'=>'yxl001','user_sn'=>'SYSUSER|9da548a2e392a679eb274a0b2abeb627','parent_sn'=>'ljs'];
        $allowLoginUser = $this->getAllowLoginUser();
        if(empty($param['username']) || empty($param['password'] )){
            return $this->errorWithInfo('用户名、密码必填', 401);
        }
        if($param['username'] != $allowLoginUser['user_name']){ //固定登录用户
            return $this->errorWithInfo('用户名不正确', 401);
        }
        
        //调用小a登录接口
        $url = "https://test117.ciopaas.com/api/login";
        $params = ['username'=>$param['username'],'password'=>$param['password'],'from'=>"2"];
        $params['url'] = substr(md5(json_encode($params)),1,8);
        $requestReturn = $this->requestPost($url,$params);
        //dump($requestReturn);
        $requestReturnArr = json_decode($requestReturn,true);
        if (isset($requestReturnArr['code'])){ //登录成功
            if ($requestReturnArr['code'] == 0){
                //dd($requestReturnArr);
                $rKey = 'strategy:login:'.$requestReturnArr['data']['user_sn'];
                $expired = 60*60*10;//从登陆后有效时长
                $r = Redis::setex($rKey,$expired,json_encode($requestReturnArr['data']));
                /* $u = Redis::get($rKey);
                dd($u); */
                return $this->successWithInfo($requestReturnArr['data']);
            }else{
                return $this->errorWithInfo($requestReturnArr['msg'], 401);
            }
        }else{
            return $this->errorWithInfo('登录接口异常', 401);
        }
        
    }
    
}
