<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
//use App\Service\StrategyService;
use App\Models\StrategySet;
use App\Jobs\StrategyTaskJob;

class CreatedTaskDataCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:CreatedTaskDataCommand';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '每月1号4点创建任务数据';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $setInfo = StrategySet::where([['disabled',0]])->get('strategy_sn')->toArray();
        if (!empty($setInfo)){
            //$StrategyService = new StrategyService();
            foreach ($setInfo as $k=>$v){
                //$StrategyService->createTaskDataJob($v['strategy_sn']);
                $jobParams = ['strategySn'=>$v['strategy_sn']];
                $job = (new StrategyTaskJob($jobParams))->onQueue('StrategyTask');
                dispatch($job);
            }
        }
    }
}
