<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\StrategyTask;
//use App\Http\Controllers\Tool;

class CreatedTaskCommand extends Command
{
    //use Tool;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:CreatedTaskCommand';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '每天早上6点创建任务';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //新建任务、失败原任务重呼3次，接口调用失败重试3次
        //$userInfo = $this->getAllowLoginUser();
        $userInfo = ['user_name'=>'yxl001','user_sn'=>'SYSUSER|9da548a2e392a679eb274a0b2abeb627','parent_sn'=>'ljs'];
        
        $taskInfo = StrategyTask::where('is_created',0)->get()->toArray(); //获取需要新建任务的数据
        $url = "https://test117.ciopaas.com/api/addJsonNoLogin";
        
        foreach ($taskInfo as $k=>$v){//批量调用接口新建任务
            //处理参数            
            $client_info_json = [
                [
                    '姓名'=>$v['name'],
                    '电话'=>$v['phone'],
                    '地址'=>'',
                    '公司名称'=>'',
                    '备注'=>'',
                    '手机号码'=>$v['phone'],
                    '值班日期'=>$v['duty_date']                    
                ]                
            ];
            
            $params = [
                'user_sn'=>$userInfo['user_sn'],
                'project_sn'=>$v['project_sn'],
                'source'=>date('YmdHis').$k, //任务名称，年月日时分秒，加上循环键值避免重复任务名
                'ai_user_sn'=>$v['user_sn'],
                'is_zidong'=>'off',//是否自动启动，否，任务定时启动
                'is_open_remove_duplication'=>'0',
                'is_auto_fail_recall'=>'1', //是否自动重呼，是
                'total_fail_recall_times'=>'3', //重呼次数
                'fail_recall_interval'=>'',//重呼间隔时间
                'mark'=>'值班策略创建任务',
                'fail_recall_of_reason'=>'关机,来电提醒,稍后再拨,停机,无法接通,正在通话中,用户正忙,用户拒接,欠费,无人应答,其他,对方示忙',
                'ai_distribution_type'=>'0'//0公用ai 1按主账号分配ai（6.2人工外呼分配方式 0平均，1抢拨）
            ];
            
            $params['client_info_json'] = json_encode($client_info_json);
            
            
            $params['url'] = substr(md5(json_encode($params)),1,8);
            $requestReturn = $this->requestPost($url,$params);
            dd($requestReturn);
            $requestReturnArr = json_decode($requestReturn,true);
            if (isset($requestReturnArr['code'])){ 
                
            }else{
                
            }
        }
        
        
    }
}
