<?php

namespace App\Http\Controllers\strategy;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\StrategyTask;
use Illuminate\Foundation\Validation\ValidatesRequests;
use App\Http\Controllers\Tool;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;

class StrategyTaskController extends Controller
{
    use ValidatesRequests;
    use Tool;
    
    public function index(Request $request){
        try{
            $pageSize = $request->pageSize;
            if (empty($pageSize)){
                $pageSize = 20;
            }
            $projectArr = $this->getAllowProjects(1);
            
            $searchArr = [];
            /* $searchArr['phone'] = request()->phone;
            $searchArr['is_created'] = request()->is_created;
            $searchArr['callTimeStart'] = request()->started_at;
            $searchArr['callTimeStop'] = request()->stoped_at; */
            
            $searchArr['phone'] = $request->phone;
            $searchArr['is_created'] = $request->is_created;
            $searchArr['callTimeStart'] = $request->started_at;
            $searchArr['callTimeStop'] = $request->stoped_at;
                        
            //Log::channel('api')->info(var_export($searchArr,true));
                        
            $strategyInfo = StrategyTask::where(function($query) use ($searchArr){
                if (isset($searchArr['phone']) && !empty($searchArr['phone'])){
                    $query->where('phone','like',"%{$searchArr['phone']}%");
                }
                if (isset($searchArr['is_created']) && is_numeric($searchArr['is_created'])){
                    $query->where('is_created',"{$searchArr['is_created']}");
                }
                
                if (isset($searchArr['callTimeStart']) && !empty($searchArr['callTimeStart'])){
                    $query->whereRaw(" call_date || ' ' || call_time >=  '{$searchArr['callTimeStart']}'");
                }
                
                if (isset($searchArr['callTimeStop']) && !empty($searchArr['callTimeStop'])){
                    $query->whereRaw(" call_date || ' ' || call_time <=  '{$searchArr['callTimeStop']}'");
                }
                
            });
            if(empty($pageSize)){
                $strategyInfo = $strategyInfo->orderBy('call_date','desc')->orderBy('call_time','desc')->get()->toArray();
            }else{
                $strategyInfo = $strategyInfo->orderBy('call_date','desc')->orderBy('call_time','desc')->paginate($pageSize)->toArray();
            }
            $listInfo = [];
            if (isset($strategyInfo['data']) && !empty($strategyInfo['data'])){        
                foreach ($strategyInfo['data'] as $k=>$v){
                    $strategyInfo['data'][$k]['project_name'] = isset($projectArr[$v['project_sn']]) ? $projectArr[$v['project_sn']] : '';
                    $strategyInfo['data'][$k]['is_created_name'] = $v['is_created'] == 0 ? '未建' : '已建';
                }
            }
            return $this->successWithInfo($strategyInfo);
        }catch (\Exception $e){
            Log::channel('api')->error($e->getFile().'-'.$e->getLine().'-'.$e->getMessage());
            return $this->errorWithInfo('操作异常', 500);
        } 
    }
    
    
    public function update(Request $request, $id)
    {
        try{
            $phone = $request->phone;
            $name = $request->name;
            $callTime = $request->call_time;            
            
            $validator = Validator::make($request->all(), [
                'phone' => 'required|regex:/^1[3-8]{1}[0-9]{9}$/',
                'user_sn' => 'required',
                'call_time' => 'required',
                'name'=>'max:20'
            ]);
            
            if ($validator->fails()) {
                return $this->errorWithInfo('表单验证失败', 401);
            }
            
            $taskInfo = StrategyTask::find($id);
            if (empty($taskInfo)){
                return $this->errorWithInfo('任务数据不存在', 401);
            }
            if ($taskInfo->is_created == 1){
                return $this->errorWithInfo('任务已经创建不能编辑', 401);
            }
            $taskInfo->phone = $phone;
            $taskInfo->name = $name;
            $taskInfo->call_time = $callTime;
            $taskInfo->save();
            return $this->successWithInfo('更新成功');
        }catch (\Exception $e){
            Log::channel('api')->error($e->getFile().'-'.$e->getLine().'-'.$e->getMessage());
            return $this->errorWithInfo('操作异常', 500);
        } 
    }
    
    
}
