<?php

namespace App\Http\Controllers\strategy;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\StrategyTask;
use Illuminate\Foundation\Validation\ValidatesRequests;
use App\Http\Controllers\Tool;

class StrategyTaskController extends Controller
{
    use ValidatesRequests;
    use Tool;
    
    public function index(){
        //搜索分页？
        $pageSize=request()->pageSize;
        $projectArr = $this->getAllowProjects(1);
        //$strategyInfo = StrategyTask::all()->toArray();
        
        $searchArr = [];
        $searchArr['phone'] = request()->phone;
        $searchArr['is_created'] = request()->is_created;
        $searchArr['callTimeStart'] = request()->started_at;
        $searchArr['callTimeStop'] = request()->stoped_at;
        
        $strategyInfo = StrategyTask::where(function($query) use ($searchArr){
            if (isset($searchArr['phone']) && !empty($searchArr['phone'])){
                $query->where('phone','like',"%{$searchArr['phone']}%");
            }
            if (isset($searchArr['is_created']) && !empty($searchArr['is_created'])){
                $query->where('is_created','like',"%{$searchArr['is_created']}%");
            }
            
            if (isset($searchArr['callTimeStart']) && !empty($searchArr['callTimeStart'])){
                $query->whereRaw(" call_date || ' ' || call_time >=  '{$searchArr['callTimeStart']}'");
            }
            
            if (isset($searchArr['callTimeStop']) && !empty($searchArr['callTimeStop'])){
                $query->whereRaw(" call_date || ' ' || call_time <=  '{$searchArr['callTimeStart']}'");
            }
            
        });
        if(empty($pageSize)){
            $strategyInfo = $strategyInfo->get()->toArray();
        }else{
            $strategyInfo = $strategyInfo->paginate($pageSize)->toArray();
        }
        
        $listInfo = [];
        foreach ($strategyInfo['data'] as $k=>$v){
            $strategyInfo['data'][$k]['project_name'] = isset($projectArr[$v['project_sn']]) ? $projectArr[$v['project_sn']] : '';
            $strategyInfo['data'][$k]['is_created_name'] = $v['is_created'] == 0 ? '未建' : '已建';
        }
        return $this->successWithInfo($strategyInfo);
    }
    
    
    public function show($strategy_sn){
        
    }
    
    public function update(Request $request, $strategy_sn)
    {
        try {
            
            
            return $this->successWithInfo('更新成功');
        } catch (\Exception $e) {            
            return $this->errorWithInfo($e->getMessageBag());
        }
    }
    
    
}
