import request from '@/utils/request'
// codes
export function fetchCodesList(query) {
  return request({
    url: '/api/codes',
    method: 'get',
    params: query
  })
}
export function addCodes(data) {
  return request({
    url: '/api/codes',
    method: 'post',
    data
  })
}
export function editCodes(data) {
  return request({
    url: '/api/codes/' + data.id,
    method: 'patch',
    data
  })
}
export function deleteCodes(id) {
  return request({
    url: '/api/codes/' + id,
    method: 'delete'
  })
}
export function deletesCodes(data) {
  return request({
    url: '/api/codes/delete',
    method: 'delete',
    data
  })
}
// project_names
export function fetchProjectNameList(query) {
  return request({
    url: '/api/project_names',
    method: 'get',
    params: query
  })
}
export function addProjectName(data) {
  return request({
    url: '/api/project_names',
    method: 'post',
    data
  })
}
export function editProjectName(data, id) {
  return request({
    url: '/api/project_names/' + id,
    method: 'patch',
    data
  })
}
export function deleteProjectName(id) {
  return request({
    url: '/api/project_names/' + id,
    method: 'delete'
  })
}
export function deletesProjectName(data) {
  return request({
    url: '/api/project_names/delete',
    method: 'delete',
    data
  })
}
// projects
export function fetchProjectsList(query) {
  return request({
    url: '/api/projects',
    method: 'get',
    params: query
  })
}
export function editProjects(data, headers = {}) {
  return request({
    headers: headers,
    url: '/api/projects/',
    method: 'post',
    data
  })
}
export function addProjects(data, headers = {}) {
  return request({
    headers: headers,
    url: '/api/projects',
    method: 'post',
    data
  })
}
export function deleteProjects(id) {
  return request({
    url: '/api/projects/' + id,
    method: 'delete'
  })
}

// 服务配置
export function fetchServiceList(query) {
  return request({
    url: '/api/servers',
    method: 'get',
    params: query
  })
}
export function deleteService(id) {
  return request({
    url: '/api/servers/' + id,
    method: 'delete'
  })
}

export function addService(data) {
  return request({
    url: '/api/servers',
    method: 'post',
    data
  })
}
export function editService(data) {
  return request({
    url: '/api/servers/' + data.id,
    method: 'patch',
    data
  })
}
export function fetchServiceDic(query) {
  return request({
    url: '/api/servers/dic',
    method: 'get',
    params: query
  })
}
