<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        Commands\CreatedTaskCommand::class, //创建任务
        Commands\CreatedTaskDataCommand::class, //创建任务数据
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')
        //          ->hourly();
        $schedule->command("command:CreatedTaskCommand")->cron('0 6 * * *'); //每天6点执行，注意与command:CreatedTaskDataCommand 的前后关系
        
        $schedule->command("command:CreatedTaskDataCommand")->cron('0 4 1 * *'); //每月1号5点执行
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
