/* eslint-disable indent */
import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router)

/* Layout */
import Layout from '@/layout'

/* Router Modules */

/**
 * Note: sub-menu only appear when route children.length >= 1
 * Detail see: https://panjiachen.github.io/vue-element-admin-site/guide/essentials/router-and-nav.html
 *
 * hidden: true                   if set true, item will not show in the sidebar(default is false)
 * alwaysShow: true               if set true, will always show the root menu
 *                                if not set alwaysShow, when item has more than one children route,
 *                                it will becomes nested mode, otherwise not show the root menu
 * redirect: noRedirect           if set noRedirect will no redirect in the breadcrumb
 * name:'router-name'             the name is used by <keep-alive> (must set!!!)
 * meta : {
    roles: ['admin','editor']    control the page roles (you can set multiple roles)
    title: 'title'               the name show in sidebar and breadcrumb (recommend set)
    icon: 'svg-name'             the icon show in the sidebar
    noCache: true                if set true, the page will no be cached(default is false)
    affix: true                  if set true, the tag will affix in the tags-view
    breadcrumb: false            if set false, the item will hidden in breadcrumb(default is true)
    activeMenu: '/example/list'  if set path, the sidebar will highlight the path you set
  }
 */

/**
 * constantRoutes
 * a base page that does not have permission requirements
 * all roles can be accessed
 */
export const constantRoutes = [{
  path: '/redirect',
  component: Layout,
  hidden: true,
  children: [{
    path: '/redirect/:path(.*)',
    component: () => import('@/views/redirect/index')
  }]
},
{
  path: '/',
  component: Layout,
  redirect: '/dashboard',
  children: [{
    path: 'dashboard',
    component: () => import('@/views/dashboard/index'),
    name: 'Dashboard',
    meta: {
      title: '外呼策略',
      // icon: 'dashboard',
      affix: true
    }
  }]
},
{
  path: '/strategy/taskdata',
  component: Layout,
  children: [{
    path: 'index',
    component: () => import('@/views/task-data/index'),
    name: 'TaskData',
    meta: {
      title: '任务数据'
      // ,icon: 'dashboard'
    }
  }]
},

// {
//   path: '/strategy',
//   component: Layout,
//   meta: {
//     title: '外呼策略',
//     icon: 'dashboard'
//   },
//   redirect: '/strategy/index',
//   children: [{
//     path: 'index',
//     component: () => import('@/views/strategy/index'),
//     name: 'Strategy',
//     meta: {
//       title: '外呼策略',
//       icon: 'dashboard'
//     }
//   }, {
//     path: 'taskdata',
//     component: () => import('@/views/task-data/index'),
//     name: 'TaskData',
//     meta: {
//       title: '任务数据',
//       icon: 'dashboard'
//     }
//   }]
// },
{
  path: '/account-set',
  hidden: true,
  component: Layout,
  children: [{
    path: 'index',
    component: () => import('@/views/account-set/index'),
    name: 'AccountSet',
    meta: {
      title: '账号设置',
      icon: 'dashboard'
    }
  }]
},

{
  path: '/login',
  component: () => import('@/views/login/index'),
  hidden: true
},
{
  path: '/auth-redirect',
  component: () => import('@/views/login/auth-redirect'),
  hidden: true
},
{
  path: '/404',
  component: () => import('@/views/error-page/404'),
  hidden: true
},
{
  path: '/401',
  component: () => import('@/views/error-page/401'),
  hidden: true
},
{
  path: '/error',
  component: Layout,
  redirect: 'noRedirect',
  name: 'ErrorPages',
  hidden: true,
  meta: {
    title: 'Error Pages',
    icon: '404'
  },
  children: [{
    path: '401',
    component: () => import('@/views/error-page/401'),
    name: 'Page401',
    meta: {
      title: '401',
      noCache: true
    }
  },
  {
    path: '404',
    component: () => import('@/views/error-page/404'),
    name: 'Page404',
    meta: {
      title: '404',
      noCache: true
    }
  }
  ]
},
{
  path: '*',
  redirect: '/404',
  hidden: true
}
]

/**
 * asyncRoutes
 * the routes that need to be dynamically loaded based on user roles
 */
export const asyncRoutes = [
  // {
  //   path: '/documentation',
  //   component: Layout,
  //   hidden: true,
  //   children: [{
  //     path: 'index',
  //     component: () => import('@/views/documentation/index'),
  //     name: 'Documentation',
  //     meta: {
  //       title: 'Documentation',
  //       icon: 'documentation'
  //       , roles: ['user']
  //     }
  //   }]
  // }
]

const createRouter = () => new Router({
  // mode: 'history', // require service support
  scrollBehavior: () => ({
    y: 0
  }),
  routes: constantRoutes
})

const router = createRouter()

export function resetRouter() {
  const newRouter = createRouter()
  router.matcher = newRouter.matcher // reset router
}

export default router
