<?php

namespace App\Http\Middleware;

use Closure;
use App\Http\models\users;
use Illuminate\Support\Facades\Log;
use App\User;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Tool;
class CheckApiKey
{
    use Tool;
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        try {
            $url=$request->url;            
            $api_key=$request->api_key;
            $user_sn=$request->user_sn;
            
            if (empty($api_key) || empty($user_sn)){
                return $this->errorWithInfo('参数验证不通过', 401);
            }
            
            $param = $request->except(['url','client_info_json','source','aes','upload','fail_recall_of_reason']);
            
            Log::channel('api')->info('API_PARAM:'.json_encode($param));
            Log::channel('api')->info('API_SERVER_PARAM:'.substr(md5(json_encode($param)),1,8));
            /* Log::channel('api')->info('API_CLIENT_PARAM:'.$url);
            
            $md_url = substr(md5(json_encode($param)),1,8);
            
            if(strcmp($url,$md_url)){
                if($_SERVER['REQUEST_SCHEME'] == 'http'){
                    return $this->errorWithInfo('验证url失败', 401);
                }
            } */

            $user = DB::table('users')->where('user_sn',$param['user_sn'])->first();

            if(empty($user->parent_sn)){
                $the_expired = $user->expired;
            }else{
                $puser = DB::table('users')->where('user_name',$user->parent_sn)->select('expired')->first();
                $the_expired = $puser->expired;
            }
            if ($api_key != $user->api_key){
                return $this->errorWithInfo('key验证失败', 401);
            }
            $todayDate = strtotime(date('y-m-d 00:00:00',time()));
            $expiredDate =strtotime($the_expired. ' 00:00:00');
        
            if(empty($the_expired) || $expiredDate - $todayDate <= 0){
                 return $this->errorWithInfo('您的账号已过期，请联系管理员处理', 401);
            }
  
            $request->attributes->add(['user'=>$user]);//添加参数
        }catch (\Exception $e){
            Log::channel('api')->error($e->getFile().'-'.$e->getLine().'-'.$e->getMessage());
            return $this->errorWithInfo('验证异常', 401);
        }   
        return $next($request);
    }
}
