<?php

namespace App\Http\Controllers\strategy;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\StrategyTask;
use Illuminate\Foundation\Validation\ValidatesRequests;
use App\Http\Controllers\Tool;

class StrategyTaskController extends Controller
{
    use ValidatesRequests;
    use Tool;
    
    public function index(){
        //搜索分页？
        
        $projectArr = $this->getAllowProjects(1);
        $strategyInfo = StrategyTask::all()->toArray();
        $listInfo = [];
        foreach ($strategyInfo as $k=>$v){
            $projectSnTemp = explode("#", $v['project_sn']);
            $v['project_name'] = isset($projectArr[$projectSnTemp[0]]) ? $projectArr[$projectSnTemp[0]] : '';
            if (isset($projectSnTemp[1]) && isset($projectArr[$projectSnTemp[1]])){
                $v['project_name'] .= $projectArr[$projectSnTemp[1]];
            }
            $v['is_created_name'] = $v['is_created'] == 0 ? '未建' : '已建';
            $listInfo[] = $v;
        }
        return $this->successWithInfo(['data'=>$listInfo]);
    }
    
    
    public function show($strategy_sn){
        
    }
    
    public function update(Request $request, $strategy_sn)
    {
        try {
            
            
            return $this->successWithInfo('更新成功');
        } catch (\Exception $e) {            
            return $this->errorWithInfo($e->getMessageBag());
        }
    }
    
    
}
