<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

//接口路由
Route::post('login', 'LoginApiController@index');

Route::group(['middleware' => 'check.apikey','namespace'=>'strategy'], function () {    
    
    Route::post('strategy/getProjectsList', 'StrategySetController@getProjectsList')->name('strategy.getProjectsList');//项目列表 
    
    Route::get('strategy/downloadModel', 'StrategySetController@downloadModel')->name('strategy.downloadModel');//导出模板
    
    Route::get('strategy/downloadFailExcel', 'StrategySetController@downloadFailExcel')->name('strategy.downloadFailExcel');//下载失败导入excel数据
    
    Route::apiResource('strategySet', StrategySetController::class);
    
});
    

